package org.msh.tb.entities.enums;

import org.msh.tb.bd.tbforms.dhis2.SexCategoryOptionCombo;

/**
 * Created by Mauricio on 04/03/2017.
 */
public enum TbFormField {

    // Presumptive TB Microscopy Tested Male
    TB10_BLOCK3_FIELD1("presTBTestedMicroscopyMale", "o0rtHyCdlL9", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB Microscopy Tested Female
    TB10_BLOCK3_FIELD2("presTBTestedMicroscopyFemale", "o0rtHyCdlL9", SexCategoryOptionCombo.FEMALE.getCocId()),
    // Presumptive TB Positive Microscopy Male
    TB10_BLOCK3_FIELD3("presTBPositiveMicroscopyMale", "pAo4n4b1eV7", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB Positive Microscopy Female
    TB10_BLOCK3_FIELD4("presTBPositiveMicroscopyFemale", "pAo4n4b1eV7", SexCategoryOptionCombo.FEMALE.getCocId()),

    // Presumptive TB Xpert Tested Male
    TB10_BLOCK4_FIELD1("presTBTestedXpertMale", "y8hScFUESiN", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB Xpert Tested Female
    TB10_BLOCK4_FIELD2("presTBTestedXpertFemale", "y8hScFUESiN", SexCategoryOptionCombo.FEMALE.getCocId()),
    // Presumptive TB Positive Xpert Male
    TB10_BLOCK4_FIELD3("presTBPositiveXpertMale", "iH9ZvASuDeD", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB Positive Xpert Female
    TB10_BLOCK4_FIELD4("presTBPositiveXpertFemale", "iH9ZvASuDeD", SexCategoryOptionCombo.FEMALE.getCocId()),

    // Presumptive TB PLWHA Tested for AFB Male
    TB10_BLOCK5B_FIELD1("presHivMicroscopyTestedMale", "cOLdH1UPhtu", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB PLWHA Tested for AFB Female
    TB10_BLOCK5B_FIELD2("presHivMicroscopyTestedFemale", "cOLdH1UPhtu", SexCategoryOptionCombo.FEMALE.getCocId()),
    // Presumptive TB PLWHA Positive for AFB Male
    TB10_BLOCK5B_FIELD3("presHivPositiveMicroscopyMale", "BViFCxc4rLw", SexCategoryOptionCombo.MALE.getCocId()),
    // Presumptive TB PLWHA Positive for AFB Female
    TB10_BLOCK5B_FIELD4("presHivPositiveMicroscopyFemale", "BViFCxc4rLw", SexCategoryOptionCombo.FEMALE.getCocId()),

    // PAL Attended Male
    TB10_BLOCK6A_FIELD1("palAttendedMale", "EeTSSVzepxp", SexCategoryOptionCombo.MALE.getCocId()),
    // PAL Attended Female
    TB10_BLOCK6A_FIELD2("palAttendedFemale", "EeTSSVzepxp", SexCategoryOptionCombo.FEMALE.getCocId()),
    // PAL Presumptive Tested Male
    TB10_BLOCK6B_FIELD1("palPresTestedMale", "z9HAk8uAzfI", SexCategoryOptionCombo.MALE.getCocId()),
    // PAL Presumptive Tested Female
    TB10_BLOCK6B_FIELD2("palPresTestedFemale", "z9HAk8uAzfI", SexCategoryOptionCombo.FEMALE.getCocId()),
    // PAL TB Patient Diagnosed Male
    TB10_BLOCK6C_FIELD1("palTBPatientDiagMale", "tYRsbi9LWg3", SexCategoryOptionCombo.MALE.getCocId()),
    // PAL TB Patient Diagnosed Male
    TB10_BLOCK6C_FIELD2("palTBPatientDiagFemale", "tYRsbi9LWg3", SexCategoryOptionCombo.FEMALE.getCocId()),

    // TB 11 block 3 - IPT - No. of eligeble Child for IPT - Male
    TB11_IPT_COLUMN1_MALE("childForIptMale", "HmzdhkFSOWZ", SexCategoryOptionCombo.MALE.getCocId()),
    // TB 11 - IPT - No. of eligeble Child for IPT - Female
    TB11_IPT_COLUMN1_FEMALE("childForIptFemale", "HmzdhkFSOWZ", SexCategoryOptionCombo.FEMALE.getCocId()),
    // TB 11 - IPT - IPT Started - Male
    TB11_IPT_COLUMN2_MALE("iptStartedMale", "SboSJcq6FpH", SexCategoryOptionCombo.MALE.getCocId()),
    // TB 11 - IPT - IPT Started - Female
    TB11_IPT_COLUMN2_FEMALE("iptStartedFemale", "SboSJcq6FpH", SexCategoryOptionCombo.FEMALE.getCocId()),
    // TB 11 - IPT - IPT Completed - Male
    TB11_IPT_COLUMN3_MALE("iptCompletedMale", "yhuTQlD5Ngk", SexCategoryOptionCombo.MALE.getCocId()),
    // TB 11 - IPT - IPT Completed - Female
    TB11_IPT_COLUMN3_FEMALE("iptCompletedFemale", "yhuTQlD5Ngk", SexCategoryOptionCombo.FEMALE.getCocId()),

    // Dashboard indicator 11, not used in DHIS2 !!!
    TB10_TOTAL_CASES_PRESENTED_MANUALLY("totalCasesPresentedManually", "", "");

    /**
     * The field name in DTO object, used to feed those fields by Reflection
     */
    private String dtoFieldName;

    /**
     * The dhis2 data element id, used on dhis2 integration
     */
    private String dhis2DataElementId;

    /**
     * The dhis2 category option combo id, used on dhis2 integration
     */
    private String dhis2CategoryOptionComboId;

    TbFormField(String dtoFieldName, String dhis2DataElementId, String dhis2CategoryOptionComboId) {
        this.dtoFieldName = dtoFieldName;
        this.dhis2DataElementId = dhis2DataElementId;
        this.dhis2CategoryOptionComboId = dhis2CategoryOptionComboId;
    }

    public String getDtoFieldName() {
        return dtoFieldName;
    }

    public String getDhis2DataElementId() {
        return dhis2DataElementId;
    }

    public String getDhis2CategoryOptionComboId() {
        return dhis2CategoryOptionComboId;
    }

    public String getKey() {
        return getClass().getSimpleName().concat("." + name());
    }

}
